/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.schedops.schedulables;

import com.ibm.hsc.common.util.Crypt;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.HMCSchedulable;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.schedops.SchedulableException;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BackupCritDataPSchedulable
implements HMCSchedulable {
    private static final String CLASS_NAME = "[BackupCritDataPSchedulable] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String BLANK = " ";
    private static final String AS_ROOT = "/opt/hsc/bin/hscdc ";
    private static final String COMMAND = "/opt/hsc/bin/backuphdr";
    private static final int BACKUP_TYPE = 0;
    private static final String FILENAME_PREFIX = "HMCBackup_";
    private static final String DATE_FORMAT = "yyyyMMdd.HHmmss";
    private static final String FILENAME_SUFFIX = ".tgz";
    private SchedulableDescriptor descriptor = null;

    public BackupCritDataPSchedulable() {
        Trace.trace((String)TRACE_MASKT, (Object)"[BackupCritDataPSchedulable] <> BackupCritDataPSchedulable()");
    }

    protected BackupCritDataPSchedulable(PersistentData persistentData) {
        Trace.trace((String)TRACE_MASKT, (Object)"[BackupCritDataPSchedulable] <> BackupCritDataPSchedulable( PersistentData )");
    }

    public synchronized SchedulableDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor();
        }
        return this.descriptor;
    }

    public Object performScheduledOperation(ScheduledOperation scheduledOperation) throws SchedulableException {
        Trace.trace((String)TRACE_MASKT, (Object)"[BackupCritDataPSchedulable] >> performScheduledOperation()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AS_ROOT);
        stringBuffer.append(Crypt.encrypt(COMMAND));
        stringBuffer.append(BLANK);
        stringBuffer.append(FILENAME_PREFIX);
        stringBuffer.append(new SimpleDateFormat(DATE_FORMAT).format(new Date()));
        stringBuffer.append(FILENAME_SUFFIX);
        stringBuffer.append(BLANK);
        stringBuffer.append(0);
        Trace.trace((String)TRACE_MASKF, (Object)("[BackupCritDataPSchedulable]    Executing command : " + stringBuffer.toString()));
        EExecResult eExecResult = null;
        eExecResult = EExec.Exec((String)stringBuffer.toString());
        int n = eExecResult.rc;
        Trace.trace((String)TRACE_MASKF, (Object)("[BackupCritDataPSchedulable]    Return Code : " + n));
        if (eExecResult.getStdout() != null) {
            Trace.trace((String)TRACE_MASKF, (Object)"[BackupCritDataPSchedulable]    StdOut : ");
            Trace.trace((String)TRACE_MASKF, (Object)eExecResult.getStdout());
        }
        if (eExecResult.getStderr() != null) {
            Trace.trace((String)TRACE_MASKF, (Object)"[BackupCritDataPSchedulable]    StdErr : ");
            Trace.trace((String)TRACE_MASKF, (Object)eExecResult.getStderr());
        }
        if (n != 0) {
            String string = "Unknown error";
            if (n == 1) {
                string = "Error locating required backup directory";
            } else if (n != 2) {
                if (n == 3) {
                    string = "Error unmounting the media";
                } else if (n == 4) {
                    string = "Media is write-protected";
                } else if (n == 5) {
                    string = "Error mounting the media";
                } else if (n == 6) {
                    string = "Other errors ('tar' command error)";
                }
            }
            throw new SchedulableException("Backup Crit Data : RC = " + n + " : " + string);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"[BackupCritDataPSchedulable] << performScheduledOperation()");
        return null;
    }

    public PersistentData getPersistentData() {
        return new PersistedData();
    }

    public boolean isUpgradeData() {
        return false;
    }

    public static class Descriptor
    implements SchedulableDescriptor {
        public LocalizableText getDescription() {
            return new LocalizableText("com.ibm.hsc.auiml.databeans.schedops.message", "BACKUP_CRITDATA.DISPLAY");
        }

        public Schedulable createSchedulable(OperationTarget operationTarget) {
            return new BackupCritDataPSchedulable();
        }

        public boolean isDisplayableOnUI(OperationTarget operationTarget) {
            return true;
        }

        public boolean isSelectableOnUI(OperationTarget operationTarget) {
            return true;
        }

        public String getOperationParametersTasklet() {
            return null;
        }
    }

    private static class PersistedData
    implements PersistentData {
        private PersistedData() {
        }
    }
}

